---
generated_at: 2026-01-27 13:01:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-ci.yml - e2e job.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/ci.yml` - CIワークフロー定義（e2eジョブ）
- E-02: `test/e2e/puppeteer.js` - E2Eテスト実装（CI環境変数処理）
- E-03: `package.json` - npm scripts定義
- E-04: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブ名は"E2E testing" | E-01 (line 41) | ○ |
| C-02 | matrix.os=[ubuntu-latest] | E-01 (line 47) | ○ |
| C-03 | matrix.CI=[0,1,2,3,4] | E-01 (line 48) | ○ |
| C-04 | timeout-minutes: 30 | E-01 (line 43) | ○ |
| C-05 | fail-fast: false | E-01 (line 45) | ○ |
| C-06 | CI環境変数をmatrix.CIから設定 | E-01 (lines 49-50) | ○ |
| C-07 | actions/checkout@v6を使用 | E-01 (line 53) | ○ |
| C-08 | actions/setup-node@v6を使用 | E-01 (line 55) | ○ |
| C-09 | Node.js 24を使用 | E-01 (line 57) | ○ |
| C-10 | npmキャッシュを有効化 | E-01 (line 58) | ○ |
| C-11 | npm ciで依存関係インストール | E-01 (line 60) | ○ |
| C-12 | npm run build-moduleでビルド | E-01 (lines 61-62) | ○ |
| C-13 | npm run test-e2eでE2Eテスト | E-01 (lines 64-65) | ○ |
| C-14 | actions/upload-artifact@v6を使用 | E-01 (line 67) | ○ |
| C-15 | if: alwaysでアップロード | E-01 (line 68) | ○ |
| C-16 | Artifact名は"Output screenshots-{os}-{CI}" | E-01 (line 70) | ○ |
| C-17 | if-no-files-found: ignore | E-01 (line 72) | ○ |
| C-18 | CI環境変数でexamplesを5分割 | E-02 (lines 206-215) | ○ |
| C-19 | numCIJobs=5 | E-02 (line 105) | ○ |
| C-20 | 出力先はtest/e2e/output-screenshots | E-01 (line 71), E-02 (line 147) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー定義とpuppeteer.jsから完全に処理内容を把握可能
- 0: 低リスク - マトリックス戦略と並列分割ロジックが整合

## 6) レビュアーチェックリスト（最小）
- [ ] 5並列でexamplesが均等に分割されているか確認
- [ ] timeout-minutes: 30が実際の実行時間に対して適切か確認
- [ ] fail-fast: falseにより全ジョブの結果を取得できているか確認
